import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    allState: [],
    loading: false,
};

export const getStates = createAsyncThunk(
    "user/getStates",
    async ({ stateUrl, access_token }) => {
        const response = await queryResponse(stateUrl, "GET", access_token);
        return response;
    }
);

const getStatesSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetState: (state) => {
            state.allState = [];
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getStates.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getStates.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                let updateStates = [];
                for (let states of records?.data) {
                    updateStates.push(states);
                }
                state.allState = updateStates;
            }
            state.loading = false;
        });
        builder.addCase(getStates.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { resetState } = getStatesSlice.actions;
export default getStatesSlice.reducer;
